(function() {
  //farmerswife SL - 19/03/2014
  define(['jquery', 'Backbone', 'Backbone.LocalStorage', 'moment', 'models/todo/TodoModel', 'models/request/RequestModel'], function($, Backbone, LocalStorage, Moment, TodoModel, RequestModel) {
    var TodoCollection;
    return TodoCollection = (function() {
      class TodoCollection extends Backbone.Collection {
        initialize() {
          return this.reqMdl = new RequestModel();
        }

        comparator(todo) {
          return Moment(todo.get('forDate'));
        }

        byType(type) {
          var filtered;
          filtered = this.filter(function(todo) {
            var ref, ref1;
            if (!todo.get('recent')) {
              if (todo.get('todoID') === 'new' && !todo.get('silent')) {
                if (type === 'forMe' && !todo.get('assignedToID')) {
                  return true;
                }
                if (type === 'forAnotherByMe' && todo.get('assignedToID')) {
                  return true;
                }
              } else if (type === 'forAnotherByMe') {
                return (ref = todo.get('type')) === 'contactForAnotherByMe' || ref === 'forAnotherByMe';
              } else {
                return (todo.get('type') === type) || (type === 'forMe' && ((ref1 = todo.get('type')) === "contactForMe" || ref1 === "forMeByAnother"));
              }
            }
          });
          return new TodoCollection(filtered).sort();
        }

        byTime(time) {
          var filtered, now;
          now = Moment();
          filtered = this.filter(function(todo) {
            var dat;
            if (todo.get('forDate')) {
              dat = Moment(todo.get('forDate'));
            } else {
              dat = Moment(todo.get('forDateAndTime'));
            }
            if (time === 'today') {
              return dat.format('D M YY') === now.format('D M YY');
            }
            if (time === 'future') {
              return (dat > now) && dat.format('D M YY') !== now.format('D M YY');
            }
            if (time === 'past') {
              return (dat < now) && dat.format('D M YY') !== now.format('D M YY');
            }
          });
          return new TodoCollection(filtered).sort();
        }

        get_todos(usr) {
          var jsonReq, response, that, xmlReq;
          jsonReq = this.reqMdl.get('JGetTodos');
          this.reqMdl.__setNodeValue(jsonReq, 'sessionID', usr.get('sessionID'));
          this.reqMdl.__setNodeValue(jsonReq, 'includeRecent', '1');
          xmlReq = this.reqMdl.__getXML(jsonReq);
          that = this;
          response = this.reqMdl.__send_server_xmlrequest(xmlReq);
          response.done(function(data, textStatus, jqXHR) {
            var jsonObj, ref, ref1, todos;
            jsonObj = data;
            if (jsonObj.Result.isError === "0" || jsonObj.Result.isError === 0) {
              if (((ref = jsonObj.Result) != null ? ref.cacheIsUpToDate : void 0) === 1) {
                return that.trigger('collectionTodosFilled');
              } else {
                todos = jsonObj.Result.Todo;
                that.reset({
                  silent: true
                });
                _.each((ref1 = window.localStorage.getItem("Todos")) != null ? ref1.split(',') : void 0, function(todo) {
                  return window.localStorage.removeItem("Todos-" + todo);
                });
                window.localStorage.setItem('Todos', "");
                if (_.isArray(todos)) {
                  _.each(todos, function(r) {
                    return that.create(r);
                  });
                } else if (todos) {
                  that.create(todos);
                }
                return that.trigger('collectionTodosFilled');
              }
            } else {
              if (jsonObj.Result.isExpiredSession === '1' || jsonObj.Result.isExpiredSession === 1) {
                window.localStorage.clear();
                return window.location.href = 'index.html?expired=1';
              }
            }
          }).fail(function(data, textStatus, jqXHR) {
            //console.log "ERROR #{textStatus} "+data
            return false;
          });
          return this;
        }

      };

      TodoCollection.prototype.model = TodoModel;

      TodoCollection.prototype.localStorage = new LocalStorage('Todos');

      return TodoCollection;

    }).call(this);
  });

}).call(this);
